var items : GUITexture[];
var activeColor = Color.yellow * 0.5;
var rocketPrefab : GameObject;
var earthPrefab : GameObject;
private var index = 0;
var credits : SmoothMover[];
var creditsAudio : AudioClip;

function Start() {
	items[index].color = activeColor;
	LaunchDemoRocket(Vector3(0, 0, 3).normalized * 4, Vector3(-1, 1, 0.2).normalized, 3.5);
	LaunchDemoRocket(Vector3(0, 0, 3).normalized * 4.5, Vector3(1, 1, 0.2).normalized, 3.5);
}

function LaunchDemoRocket(pos, dir, pw)
{ 
	var r1 : GameObject = Instantiate(rocketPrefab, pos, Quaternion.AngleAxis (0, dir));
	var rscript = r1.GetComponent("RocketScript");
	rscript.speedDirection = dir;
	rscript.speed = pw;
	rscript.Init(false); 
	
}

function Update() {
	var newIndex = index;
	if (Input.GetKeyDown("up")) {
		--newIndex;
		if (newIndex<0)
			newIndex = items.Length-1;
	}
	if (Input.GetKeyDown("down")) {
		++newIndex;
		if (newIndex>=items.Length)
			newIndex = 0;
	}
	if (newIndex != index) {
		items[index].color = Color.white * 0.5;
		items[newIndex].color = activeColor;
		index = newIndex;
	}
	
	if (Input.GetKeyDown("space") || Input.GetKeyDown("return")) {
		switch (index) {
		case 0: DoStart(); break;
		case 1: DoCredits(); break;
		case 2: DoQuit(); break;
		}
	}
}


function DoStart() {
	Application.LoadLevel(Application.loadedLevel+1);
}

function DoCredits() {
	AudioSource.PlayClipAtPoint (creditsAudio, Vector3.zero, 1.0);
	for (var cr : SmoothMover in credits)
		cr.gameObject.active = true;
}

function DoQuit() {
	Application.Quit();
}
